Guía Definitiva de Yii 2.0
==========================

Este tutorial está liberado bajo los [Términos de Documentación Yii](http://www.yiiframework.com/doc/terms/).

Todos los derechos reservados.

2014 (c) Yii Software LLC.


Introducción
------------

* [Acerca de Yii](intro-yii.md)
* [Actualizando desde Yii 1.1](intro-upgrade-from-v1.md)


Comenzando
----------

* [Instalando Yii](start-installation.md)
* [Corriendo Aplicaciones](start-workflow.md)
* [Diciendo Hola](start-hello.md)
* [Trabajando con Formularios](start-forms.md)
* [Trabajando con Bases de Datos](start-databases.md)
* [Generando Código con Gii](start-gii.md)
* [Mirando Hacia Adelante](start-looking-head.md)


Estructura de una Aplicación
----------------------------

* [Pantallazo](structure-overview.md)
* [Scripts de Entrada](structure-entry-scripts.md)
* [Aplicaciones](structure-applications.md)
* [Componentes de una Aplicación](structure-application-components.md)
* [Controladores](structure-controllers.md)
* [Modelos](structure-models.md)
* [Vistas](structure-views.md)
* **TBD** [Filtros](structure-filters.md)
* **TBD** [Widgets](structure-widgets.md)
* **TBD** [Módulos](structure-modules.md)
* [Assets](structure-assets.md)
* **TBD** [Extensiones](structure-extensions.md)


Manejando Requests
------------------

* **TBD** [Bootstrapping](runtime-bootstrapping.md)
* **TBD** [Routing](runtime-routing.md)
* **TBD** [Requests](runtime-requests.md)
* **TBD** [Responses](runtime-responses.md)
* **TBD** [Sesiones y Cookies](runtime-sessions-cookies.md)
* [Parseando y Generando URLs](runtime-url-handling.md)
* [Manejando Errores](runtime-handling-errors.md)
* [Logging](runtime-logging.md)


Conceptos Clave
---------------

* [Componentes](concept-components.md)
* [Propiedades](concept-properties.md)
* [Eventos](concept-events.md)
* [Comportamientos (Behaviors)](concept-behaviors.md)
* [Configuraciones](concept-configurations.md)
* [Alias](concept-aliases.md)
* [Autocargando Clases](concept-autoloading.md)
* [Localizador de Servicios (Service Locator)](concept-service-locator.md)
* [Inyección de Dependencias](concept-di-container.md)


Trabajando con Bases de Datos
-----------------------------

* [Data Access Objects](db-dao.md) - Conectando a una base de datos, consultas básicas, transacciones y manipulación de esquemas
* [Query Builder](db-query-builder.md) - Consultando la base de datos utilizando una simple capa de abstracción
* [Active Record](db-active-record.md) - El ORM Active Record, trayendo y manipulando registros y definiendo relaciones
* [Migraciones](db-migrations.md) - Versionando tus bases de datos en el entorno de un equipo de desarrollo
* **TBD** [Sphinx](db-sphinx.md)
* **TBD** [Redis](db-redis.md)
* **TBD** [MongoDB](db-mongodb.md)
* **TBD** [ElasticSearch](db-elastic-search.md)


Obteniendo Datos de Usuarios
----------------------------

* [Creando Formularios](input-forms.md)
* [Validando Datos](input-validation.md)
* **TBD** [Subiendo Archivos](input-file-upload.md)
* **TBD** [Obteniendo Datos de Múltiples Modelos](input-multiple-models.md)


Mostrando Datos
---------------

* **TBD** [Formato de Datos](output-formatting.md)
* **TBD** [Paginación](output-pagination.md)
* **TBD** [Ordenando](output-sorting.md)
* [Data Providers](output-data-providers.md)
* [Data Widgets](output-data-widgets.md)
* [Utilizando Themes](output-theming.md)


Seguridad
---------

* [Autenticación](security-authentication.md)
* [Autorización](security-authorization.md)
* [Trabajando con Contraseñas](security-passwords.md)
* **TBD** [Auth Clients](security-auth-clients.md)
* **TBD** [Buenas Prácticas](security-best-practices.md)


Caching
-------

* [Pantallazo](caching-overview.md)
* [Caching de Datos](caching-data.md)
* [Caching de Fragmentos](caching-fragment.md)
* [Caching de Páginas](caching-page.md)
* [Caching HTTP](caching-http.md)


RESTful Web Services
--------------------

* [Guía Breve](rest-quick-start.md)
* [Recursos (Resources)](rest-resources.md)
* [Controladores](rest-controllers.md)
* [Routing](rest-routing.md)
* [Response Formatting](rest-response-formatting.md)
* [Autenticación](rest-authentication.md)
* [Límite de Rango](rest-rate-limiting.md)
* [Versionando](rest-versioning.md)
* [Manejando Errores](rest-error-handling.md)


Herramientas de Desarrollo
--------------------------

* [Depurador y Barra de Herramients de Depuración](tool-debugger.md)
* [Generando Código con Gii](tool-gii.md)
* **TBD** [Generando Documentación de API](tool-api-doc.md)


Testing
-------

* [Pantallazo](test-overview.md)
* **TBD** [Tests de Unidad](test-unit.md)
* **TBD** [Tests Funcionales](test-functional.md)
* **TBD** [Tests de Aceptación](test-acceptance.md)
* [Fixtures](test-fixtures.md)


Extendiendo Yii
---------------

* [Creando Extensiones](extend-creating-extensions.md)
* [Personalizando el Código del Núcleo](extend-customizing-core.md)
* [Utilizando Librerías de Terceros](extend-using-libs.md)
* **TBD** [Utilizando Yii en Sistemas de Terceros](extend-embedding-in-others.md)
* **TBD** [Utilizando Yii 1.1 y 2.0 Juntos](extend-using-v1-v2.md)
* [Utilizando Composer](extend-using-composer.md)


Temas Especiales
----------------

* [Template de Aplicación Avanzada](tutorial-advanced-app.md)
* [Generando una Aplicación Desde Cero](tutorial-start-from-scratch.md)
* [Comandos de Consola](tutorial-console.md)
* [Validadores del Núcleo](tutorial-core-validators.md)
* [Internacionalización](tutorial-i18n.md)
* [Enviando Emails](tutorial-mailing.md)
* [Ajustando la Performance](tutorial-performance-tuning.md)
* **TBD** [Entorno en Hosting Compartido](tutorial-shared-hosting.md)
* [Motores de Templates](tutorial-template-engines.md)


Widgets
-------

* GridView: link to demo page
* ListView: link to demo page
* DetailView: link to demo page
* ActiveForm: link to demo page
* Pjax: link to demo page
* Menu: link to demo page
* LinkPager: link to demo page
* LinkSorter: link to demo page
* [Bootstrap Widgets](bootstrap-widgets.md)
* **TBD** [Jquery UI Widgets](jui-widgets.md)


Helpers
-------

* [Pantallazo](helper-overview.md)
* **TBD** [ArrayHelper](helper-array.md)
* **TBD** [Html](helper-html.md)
* **TBD** [Url](helper-url.md)
* **TBD** [Security](helper-security.md)

