Маршрутизация
=============

Имея готовые классы ресурсов и контроллеров, можно получить доступ к ресурсам, используя URL вроде
`http://localhost/index.php?r=user/create`, подобно тому, как вы это делаете с обычными Web-приложениями.

На деле вам обычно хочется включить «красивые» URL-адреса и использовать все преимущества HTTP-методов (HTTP-verbs).
Например, чтобы запрос `POST /users` означал обращение к действию `user/create`.
Это может быть легко сделано с помощью настройки компонента приложения `urlManager` в 
конфигурации приложения следующим образом:

```php
'urlManager' => [
    'enablePrettyUrl' => true,
    'enableStrictParsing' => true,
    'showScriptName' => false,
    'rules' => [
        ['class' => 'yii\rest\UrlRule', 'controller' => 'user'],
    ],
]
```

Главная новинка в коде выше по сравнению с управлением URL-адресами в Web-приложениях состоит в использовании
[[yii\rest\UrlRule]] для маршрутизации запросов к RESTful API. Этот особый класс URL-правил будет
создавать целый набор дочерних URL-правил для поддержки маршрутизации и создания URL-адресов для указанного контроллера (или контроллеров).
Например, приведенный выше код является приближенным аналогом следующего набора правил:

```php
[
    'PUT,PATCH users/<id>' => 'user/update',
    'DELETE users/<id>' => 'user/delete',
    'GET,HEAD users/<id>' => 'user/view',
    'POST users' => 'user/create',
    'GET,HEAD users' => 'user/index',
    'users/<id>' => 'user/options',
    'users' => 'user/options',
]
```

Этим правилом поддерживаются следующие точки входа в API:

* `GET /users`: разбитый на страницы список всех пользователей;
* `HEAD /users`: общая информация по списку пользователей;
* `POST /users`: создание нового пользователя;
* `GET /users/123`: подробная информация о пользователе 123;
* `HEAD /users/123`: общая информация о пользователе 123;
* `PATCH /users/123` и `PUT /users/123`: обновление пользователя 123;
* `DELETE /users/123`: удаление пользователя 123;
* `OPTIONS /users`: список HTTP-методов, поддерживаемые точкой входа `/users`;
* `OPTIONS /users/123`: список HTTP-методов, поддерживаемые точкой входа `/users/123`.

Вы можете настроить опции `only` и `except`, явно указав для них список действий, которые поддерживаются или
которые должны быть отключены, соответственно. Например:

```php
[
    'class' => 'yii\rest\UrlRule',
    'controller' => 'user',
    'except' => ['delete', 'create', 'update'],
],
```

Вы также можете настроить опции `patterns` или `extraPatterns` для переопределения существующих шаблонов или добавления новых шаблонов, поддерживаемых этим правилом.
Например, для включения нового действия `search` в точке входа `GET /users/search` настройте опцию `extraPatterns` следующим образом:

```php
[
    'class' => 'yii\rest\UrlRule',
    'controller' => 'user',
    'extraPatterns' => [
        'GET search' => 'search',
    ],
```

Как вы могли заметить, ID контроллера `user` в этих точках входа используется в форме множественного числа (как `users`).
Это происходит потому, что [[yii\rest\UrlRule]] автоматически приводит идентификаторы контроллеров к множественной форме для использования в точках входа.
Вы можете отключить такое поведение, назначив свойству [[yii\rest\UrlRule::pluralize]] значение false, или, если вы хотите использовать 
какие-то особые имена, вы можете настроить свойство [[yii\rest\UrlRule::controller]].
